/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.iw.tasks.networksettings;

import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.HSCLocalizableMsg;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.iw.WizardTaskBean;
import com.ibm.hsc.iw.WizardTaskException;
import com.ibm.hsc.iw.tasks.networksettings.NetworkSettingsConstants;
import com.ibm.hsc.iw.tasks.networksettings.NetworkSettingsValidation;
import com.ibm.hwmca.base.settings.network.NetworkInfo;
import com.ibm.hwmca.fw.log.ClassLogInfo;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import java.io.Serializable;

public class NetworkSettings1Bean
extends WizardTaskBean
implements NetworkSettingsConstants {
    public static final String BEAN_NAME = "NetworkSettings1Bean";
    private static final String TRACE_MASKD = "JNSWNS1D";
    private static final String TRACE_MASKF = "JNSWNS1F";
    private static final String TRACE_MASKT = "JNSWNS1T";
    static final short ERRID_0001 = 1;
    static final short ERRID_0002 = 2;
    static final short ERRID_0003 = 3;
    static ClassLogInfo LOG_INFO = new ClassLogInfo(-88, 126, "NetSet1Bean");
    private String m_sSystemName;
    private String m_sDomainName;
    private String m_sSystemDescription;
    private boolean m_bChangeFlag;
    private boolean m_bChangedSinceLastUpdate;

    public NetworkSettings1Bean() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings1Bean Default Constructor");
        }
        this.m_sSystemName = "";
        this.m_sDomainName = "";
        this.m_sSystemDescription = "";
        this.m_bChangeFlag = false;
        this.m_bChangedSinceLastUpdate = false;
        this.setBeanName(BEAN_NAME);
    }

    public NetworkSettings1Bean(NetworkSettings1Bean networkSettings1Bean) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings1Bean NetworkSettings1Bean Constructor");
        }
        this.bean1Copy(networkSettings1Bean);
        this.m_bChangeFlag = false;
        this.m_bChangedSinceLastUpdate = false;
    }

    public NetworkSettings1Bean(Object object) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings1Bean Object Constructor");
        }
        String string = ((PanelBean)object).getBeanName();
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "--NetworkSettings1Bean Object passed is: " + string);
        }
        if (string != null && string.length() > 0) {
            if (string.equals(BEAN_NAME)) {
                this.bean1Copy((NetworkSettings1Bean)object);
                this.m_bChangeFlag = ((NetworkSettings1Bean)object).isChanged();
                this.m_bChangedSinceLastUpdate = ((NetworkSettings1Bean)object).isChangedSinceLastUpdate();
            } else {
                this.m_sSystemName = "";
                this.m_sDomainName = "";
                this.m_sSystemDescription = "";
                this.m_bChangeFlag = false;
                this.m_bChangedSinceLastUpdate = false;
                this.setBeanName(BEAN_NAME);
                if (1 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "->NetworkSettings1Bean ERROR - incorrect object passed on object constructor:" + string);
                }
                new AusMicrocodeLog(LOG_INFO, 2, new Exception(string)).writeEntryFromTaskletClient();
            }
        } else {
            this.m_sSystemName = "";
            this.m_sDomainName = "";
            this.m_sSystemDescription = "";
            this.m_bChangeFlag = false;
            this.m_bChangedSinceLastUpdate = false;
            this.setBeanName(BEAN_NAME);
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "--NetworkSettings1Bean ERROR - incorrect object passed on object constructor");
            }
            new AusMicrocodeLog(LOG_INFO, 3).writeEntryFromTaskletClient();
        }
    }

    private void bean1Copy(NetworkSettings1Bean networkSettings1Bean) {
        this.m_sSystemName = networkSettings1Bean.getSystemName();
        this.m_sDomainName = networkSettings1Bean.getDomainName();
        this.m_sSystemDescription = networkSettings1Bean.getSystemDescription();
        this.setBeanName(networkSettings1Bean.getBeanName());
    }

    public void setSystemName(String string) throws IllegalUserDataException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings1Bean setSystemName(" + string + ")");
        }
        this.m_sSystemName = string.trim();
        this.m_bChangeFlag = true;
        this.m_bChangedSinceLastUpdate = true;
    }

    public String getSystemName() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings1Bean getSystemName returning " + this.m_sSystemName);
        }
        return this.m_sSystemName;
    }

    public void setDomainName(String string) throws IllegalUserDataException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings1Bean setDomainName(" + string + ")");
        }
        this.m_sDomainName = string.trim();
        this.m_bChangeFlag = true;
        this.m_bChangedSinceLastUpdate = true;
    }

    public String getDomainName() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings1Bean getDomainName returning " + this.m_sDomainName);
        }
        return this.m_sDomainName;
    }

    public void setSystemDescription(String string) throws IllegalUserDataException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings1Bean setSystemDescription(" + string + ")");
        }
        this.m_sSystemDescription = string.trim();
        this.m_bChangeFlag = true;
        this.m_bChangedSinceLastUpdate = true;
    }

    public String getSystemDescription() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings1Bean getSystemDescription returning " + this.m_sSystemDescription);
        }
        return this.m_sSystemDescription;
    }

    public boolean isChanged() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings1Bean isChanged returning " + this.m_bChangeFlag);
        }
        return this.m_bChangeFlag;
    }

    public boolean isChangedSinceLastUpdate() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings1Bean isChangedSinceLastUpdate returning " + this.m_bChangedSinceLastUpdate);
        }
        return this.m_bChangedSinceLastUpdate;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void load() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings1Bean load called");
        }
    }

    public Serializable nextButtonHit() throws WizardTaskException {
        int n;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings1Bean nextButtonHit called");
        }
        if (this.m_sSystemName == null || this.m_sSystemName.trim().length() <= 0) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "--NetworkSettings1Bean nextButtonHit generating WizardTaskException - system name missing ");
            }
            throw new WizardTaskException(new LocalizableText("com.ibm.hsc.common.bundles.NetworkSettingsText", "NETWORKSETTINGS_ERROR_TITLE", null), new HSCLocalizableMsg(MsgType.ERROR_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "1000", null));
        }
        int n2 = NetworkSettingsValidation.validateHostName(this.m_sSystemName);
        if (n2 != 0) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "--NetworkSettings1Bean nextButtonHit generating WizardTaskException - system name invalid- validateHostName rc = " + n2);
            }
            throw new WizardTaskException(new LocalizableText("com.ibm.hsc.common.bundles.NetworkSettingsText", "NETWORKSETTINGS_ERROR_TITLE", null), new HSCLocalizableMsg(MsgType.ERROR_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "1018", null));
        }
        if (this.m_sDomainName != null && this.m_sDomainName.trim().length() > 0 && !this.m_sDomainName.trim().equals("localdomain") && (n = NetworkSettingsValidation.validateDomainName(this.m_sDomainName)) != 0) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "--NetworkSettings1Bean nextButtonHit generating WizardTaskException - domain name invalid- validateDomainName rc = " + n);
            }
            throw new WizardTaskException(new LocalizableText("com.ibm.hsc.common.bundles.NetworkSettingsText", "NETWORKSETTINGS_ERROR_TITLE", null), new HSCLocalizableMsg(MsgType.ERROR_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "1022", null));
        }
        if (this.m_sSystemDescription != null && this.m_sSystemDescription.trim().length() > 0 && this.m_sSystemDescription.length() > 250) {
            Object[] objectArray = new String[]{Integer.toString(250)};
            throw new WizardTaskException(new LocalizableText("com.ibm.hsc.common.bundles.NetworkSettingsText", "NETWORKSETTINGS_ERROR_TITLE", null), new HSCLocalizableMsg(MsgType.ERROR_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "1015", objectArray));
        }
        return new NetworkSettings1Bean((Object)this);
    }

    public Serializable backButtonHit() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings1Bean backButtonHit called");
        }
        return new NetworkSettings1Bean((Object)this);
    }

    public void panelAction(TaskActionEvent taskActionEvent) {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "->panelAction() : \n\tBean Name     : " + this.getBeanName() + "\n\tCurrentElement: " + taskActionEvent.getCurrentElement() + "\n\tElementName   : " + taskActionEvent.getElementName() + "\n\tActionCommand : " + taskActionEvent.getActionCommand());
        }
        if (taskActionEvent != null) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "Unknown event received in panelAction(...).");
            }
            new AusMicrocodeLog(LOG_INFO, 1).writeEntryFromTaskletClient();
        }
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<-NetworkSettings1Bean panelAction(...)");
        }
    }

    public void setNetworkInfo(NetworkInfo networkInfo) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings1Bean setNetworkInfo called");
        }
        if (networkInfo.getComputerName().length() > 1) {
            this.m_sSystemName = networkInfo.getComputerName();
        }
        if (networkInfo.getDomainName().length() > 1) {
            this.m_sDomainName = networkInfo.getDomainName();
        }
        if (networkInfo.getComputerDescription().length() > 1) {
            this.m_sSystemDescription = networkInfo.getComputerDescription();
        }
    }

    public void updateBean(NetworkSettings1Bean networkSettings1Bean) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings1Bean updateBean called");
        }
        if (networkSettings1Bean.isChangedSinceLastUpdate()) {
            this.setSystemName(networkSettings1Bean.getSystemName());
            this.setDomainName(networkSettings1Bean.getDomainName());
            this.setSystemDescription(networkSettings1Bean.getSystemDescription());
        }
    }

    public void updateNetworkInfo(NetworkInfo networkInfo) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings1Bean updateNetworkInfo called");
        }
        if (this.isChangedSinceLastUpdate()) {
            networkInfo.setComputerName(this.m_sSystemName);
            networkInfo.setDomainName(this.m_sDomainName);
            networkInfo.setComputerDescription(this.m_sSystemDescription);
            this.m_bChangedSinceLastUpdate = false;
        }
    }
}

